<?php

namespace App\Http\Controllers;

use App\Models\Invoice;
use App\Models\Lease;
use App\Models\Owner;
use App\Models\Payment;
use App\Models\Shop;
use Illuminate\Http\Request;
use Inertia\Inertia;

class DashboardController extends Controller
{
    public function index()
    {
        $totalShops = Shop::count();
        $occupiedShops = Shop::where('status', 'occupied')->count();
        $vacantShops = Shop::where('status', 'vacant')->count();
        $totalOwners = Owner::count();

        $currentMonth = now()->format('Y-m');
        $monthlyExpected = Invoice::where('month', $currentMonth)->sum('total_amount');
        $monthlyCollected = Payment::whereHas('invoice', fn($q) => $q->where('month', $currentMonth))->sum('amount_paid');
        $pendingAmount = $monthlyExpected - $monthlyCollected;
        $overdueInvoices = Invoice::where('status', 'overdue')->count();

        $securityDepositDues = Lease::active()->selectRaw('SUM(agreed_security_deposit - security_deposit_paid) as total')->value('total') ?? 0;

        $recentPayments = Payment::with(['invoice.lease.tenant', 'invoice.lease.shop'])
            ->latest()
            ->take(10)
            ->get();

        $shops = Shop::with(['owner', 'activeLease.tenant'])->get();

        return Inertia::render('Dashboard', [
            'stats' => [
                'totalShops' => $totalShops,
                'occupiedShops' => $occupiedShops,
                'vacantShops' => $vacantShops,
                'totalOwners' => $totalOwners,
                'monthlyExpected' => (float) $monthlyExpected,
                'monthlyCollected' => (float) $monthlyCollected,
                'pendingAmount' => (float) $pendingAmount,
                'overdueInvoices' => $overdueInvoices,
                'securityDepositDues' => (float) $securityDepositDues,
            ],
            'recentPayments' => $recentPayments,
            'shops' => $shops,
        ]);
    }
}
