<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AdminOnly
{
    /**
     * Handle an incoming request.
     * Block staff from edit, update, delete operations.
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($request->user() && $request->user()->isStaff()) {
            if ($request->expectsJson() || $request->header('X-Inertia')) {
                return back()->with('error', 'You do not have permission to perform this action.');
            }

            abort(403, 'You do not have permission to perform this action.');
        }

        return $next($request);
    }
}
