<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Expense extends Model
{
    protected $fillable = [
        'type', 'category_id', 'amount', 'description',
        'date', 'reference_no', 'proof_file',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'date' => 'date',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(ExpenseCategory::class, 'category_id');
    }

    // Scope: cash in
    public function scopeCashIn($query)
    {
        return $query->where('type', 'cash_in');
    }

    // Scope: cash out
    public function scopeCashOut($query)
    {
        return $query->where('type', 'cash_out');
    }
}
