<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('meter_readings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('lease_id')->constrained('leases')->cascadeOnDelete();
            $table->string('month', 7); // YYYY-MM format
            $table->decimal('previous_reading', 12, 2);
            $table->decimal('current_reading', 12, 2);
            $table->decimal('units_consumed', 12, 2);
            $table->decimal('rate_per_unit', 8, 2);
            $table->decimal('total_amount', 12, 2);
            $table->timestamps();

            $table->unique(['lease_id', 'month']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('meter_readings');
    }
};
