<?php

namespace Database\Seeders;

use App\Models\ExpenseCategory;
use App\Models\Setting;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // Create default admin user
        User::create([
            'name' => 'Admin',
            'email' => 'admin@rentdesk.com',
            'password' => Hash::make('password'),
        ]);

        // Default settings
        $settings = [
            'business_name' => 'RentDesk',
            'business_address' => '',
            'business_phone' => '',
            'business_logo' => '',
            'default_electricity_rate' => '25',
            'invoice_prefix' => 'RD',
            'voucher_prefix' => 'OV',
        ];

        foreach ($settings as $key => $value) {
            Setting::set($key, $value);
        }

        // Default expense categories
        $incomeCategories = ['Rent Income', 'Security Deposit', 'Other Income'];
        $expenseCategories = ['Salary', 'Utility Bills', 'Office Supplies', 'Maintenance', 'Transport', 'Tea/Food', 'Miscellaneous'];

        foreach ($incomeCategories as $name) {
            ExpenseCategory::create(['name' => $name, 'type' => 'income']);
        }

        foreach ($expenseCategories as $name) {
            ExpenseCategory::create(['name' => $name, 'type' => 'expense']);
        }
    }
}
