import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout';
import { Head, Link, useForm } from '@inertiajs/react';

export default function Create({ leases }) {
    const { data, setData, post, processing, errors } = useForm({
        lease_id: '',
        month: '',
        due_date: '',
        other_charges: '',
        other_charges_description: '',
    });

    const handleSubmit = (e) => {
        e.preventDefault();
        post(route('invoices.store'));
    };

    return (
        <AuthenticatedLayout header={<h2 className="text-xl font-semibold leading-tight text-gray-800">Generate Invoice</h2>}>
            <Head title="Generate Invoice" />

            <div className="py-12">
                <div className="mx-auto max-w-2xl sm:px-6 lg:px-8">
                    <div className="overflow-hidden bg-white shadow-sm sm:rounded-lg">
                        <div className="p-6 text-gray-900">
                            <div className="flex items-center justify-between mb-6">
                                <h3 className="text-lg font-medium">Generate New Invoice</h3>
                                <Link href={route('invoices.index')} className="inline-flex items-center rounded-md bg-gray-200 px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-300">Back</Link>
                            </div>

                            <div className="mb-6 rounded-lg border border-blue-200 bg-blue-50 p-4">
                                <p className="text-sm text-blue-700">
                                    Rent, electricity and maintenance will be calculated automatically based on lease agreement and meter readings.
                                </p>
                            </div>

                            <form onSubmit={handleSubmit} className="space-y-6">
                                {/* Lease */}
                                <div>
                                    <label className="block text-sm font-medium text-gray-700">Lease <span className="text-red-500">*</span></label>
                                    <select
                                        value={data.lease_id}
                                        onChange={(e) => setData('lease_id', e.target.value)}
                                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    >
                                        <option value="">Select a lease...</option>
                                        {leases.map((lease) => (
                                            <option key={lease.id} value={lease.id}>
                                                Shop {lease.shop?.shop_number} - {lease.tenant?.name}
                                            </option>
                                        ))}
                                    </select>
                                    {errors.lease_id && <p className="mt-1 text-sm text-red-600">{errors.lease_id}</p>}
                                </div>

                                {/* Month */}
                                <div>
                                    <label className="block text-sm font-medium text-gray-700">Month <span className="text-red-500">*</span></label>
                                    <input
                                        type="month"
                                        value={data.month}
                                        onChange={(e) => setData('month', e.target.value)}
                                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    />
                                    {errors.month && <p className="mt-1 text-sm text-red-600">{errors.month}</p>}
                                </div>

                                {/* Due Date */}
                                <div>
                                    <label className="block text-sm font-medium text-gray-700">Due Date <span className="text-red-500">*</span></label>
                                    <input
                                        type="date"
                                        value={data.due_date}
                                        onChange={(e) => setData('due_date', e.target.value)}
                                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    />
                                    {errors.due_date && <p className="mt-1 text-sm text-red-600">{errors.due_date}</p>}
                                </div>

                                {/* Other Charges */}
                                <div>
                                    <label className="block text-sm font-medium text-gray-700">Other Charges</label>
                                    <input
                                        type="number"
                                        step="0.01"
                                        min="0"
                                        value={data.other_charges}
                                        onChange={(e) => setData('other_charges', e.target.value)}
                                        placeholder="0"
                                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    />
                                    {errors.other_charges && <p className="mt-1 text-sm text-red-600">{errors.other_charges}</p>}
                                </div>

                                {/* Other Charges Description */}
                                <div>
                                    <label className="block text-sm font-medium text-gray-700">Other Charges Description</label>
                                    <input
                                        type="text"
                                        value={data.other_charges_description}
                                        onChange={(e) => setData('other_charges_description', e.target.value)}
                                        placeholder="e.g. Repair charges, late fee..."
                                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                    />
                                    {errors.other_charges_description && <p className="mt-1 text-sm text-red-600">{errors.other_charges_description}</p>}
                                </div>

                                {/* Submit */}
                                <div className="flex items-center justify-end gap-4">
                                    <Link href={route('invoices.index')} className="text-sm text-gray-600 hover:text-gray-900">Cancel</Link>
                                    <button
                                        type="submit"
                                        disabled={processing}
                                        className="inline-flex items-center rounded-md bg-blue-600 px-4 py-2 text-sm font-medium text-white hover:bg-blue-700 disabled:opacity-50"
                                    >
                                        {processing ? 'Generating...' : 'Generate Invoice'}
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
