import AuthenticatedLayout from '@/Layouts/AuthenticatedLayout';
import { Head, Link, useForm, router } from '@inertiajs/react';
import { formatCurrency, formatDate, formatMonth } from '@/utils';

const reports = [
    {
        title: 'Payment Tracker',
        description: 'Track payment status of all shops for any month. See which shops are paid, pending, or overdue.',
        route: 'reports.payment-tracker',
        color: 'blue',
        icon: '📊',
    },
    {
        title: 'Monthly Collection',
        description: 'View total expected vs collected amounts for any month with invoice-level breakdown.',
        route: 'reports.collection',
        color: 'green',
        icon: '💰',
    },
    {
        title: 'Owner Wise Report',
        description: 'See rent collected and payments made per owner, with pending balances.',
        route: 'reports.owner-wise',
        color: 'purple',
        icon: '👤',
    },
    {
        title: 'Tenant Dues Report',
        description: 'View all tenants with outstanding rent or security deposit dues.',
        route: 'reports.tenant-dues',
        color: 'red',
        icon: '📋',
    },
    {
        title: 'Owner Tree Report',
        description: 'Group owners into trees and view their combined monthly & yearly income.',
        route: 'reports.owner-tree',
        color: 'indigo',
        icon: '🌳',
    },
];

const colorMap = {
    blue: 'border-blue-500 hover:bg-blue-50',
    green: 'border-green-500 hover:bg-green-50',
    purple: 'border-purple-500 hover:bg-purple-50',
    red: 'border-red-500 hover:bg-red-50',
    indigo: 'border-indigo-500 hover:bg-indigo-50',
};

export default function Index() {
    return (
        <AuthenticatedLayout header={<h2 className="text-xl font-semibold leading-tight text-gray-800">Reports</h2>}>
            <Head title="Reports" />

            <div className="py-12">
                <div className="mx-auto max-w-4xl sm:px-6 lg:px-8">
                    <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                        {reports.map((report) => (
                            <Link
                                key={report.route}
                                href={route(report.route)}
                                className={`block bg-white shadow-sm sm:rounded-lg border-l-4 p-6 transition-colors ${colorMap[report.color]}`}
                            >
                                <div className="flex items-start gap-4">
                                    <span className="text-3xl">{report.icon}</span>
                                    <div>
                                        <h3 className="text-lg font-semibold text-gray-900">{report.title}</h3>
                                        <p className="mt-1 text-sm text-gray-500">{report.description}</p>
                                    </div>
                                </div>
                            </Link>
                        ))}
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
