export function formatCurrency(amount) {
    return new Intl.NumberFormat('en-PK', {
        style: 'currency',
        currency: 'PKR',
        minimumFractionDigits: 0,
        maximumFractionDigits: 0,
    }).format(amount || 0);
}

export function formatDate(date) {
    if (!date) return '-';
    return new Date(date).toLocaleDateString('en-PK', {
        year: 'numeric',
        month: 'short',
        day: 'numeric',
    });
}

export function formatMonth(month) {
    if (!month) return '-';
    const [year, m] = month.split('-');
    const date = new Date(year, m - 1);
    return date.toLocaleDateString('en-PK', { year: 'numeric', month: 'long' });
}

export function classNames(...classes) {
    return classes.filter(Boolean).join(' ');
}
