<?php

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\LeaseController;
use App\Http\Controllers\MeterReadingController;
use App\Http\Controllers\OwnerController;
use App\Http\Controllers\OwnerPaymentController;
use App\Http\Controllers\OwnerTreeController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\ShopController;
use App\Http\Controllers\StaffController;
use App\Http\Controllers\TenantController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect()->route('login');
});

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Resource routes: index, create, store are open to all authenticated users
    // edit, update, destroy are restricted to admin only
    Route::resource('owners', OwnerController::class)->only(['index', 'show', 'create', 'store']);
    Route::resource('shops', ShopController::class)->only(['index', 'show', 'create', 'store']);
    Route::resource('tenants', TenantController::class)->only(['index', 'show', 'create', 'store']);
    Route::resource('leases', LeaseController::class)->only(['index', 'show', 'create', 'store']);
    Route::resource('meter-readings', MeterReadingController::class)->parameters(['meter-readings' => 'meterReading'])->only(['index', 'show', 'create', 'store']);
    Route::resource('invoices', InvoiceController::class)->only(['index', 'show', 'create', 'store']);
    Route::resource('payments', PaymentController::class)->only(['index', 'show', 'create', 'store']);
    Route::resource('owner-payments', OwnerPaymentController::class)->parameters(['owner-payments' => 'ownerPayment'])->only(['index', 'show', 'create', 'store']);
    Route::resource('expenses', ExpenseController::class)->only(['index', 'show', 'create', 'store']);

    // Routes open to all
    Route::post('/invoices/generate-bulk', [InvoiceController::class, 'generateBulk'])->name('invoices.generate-bulk');
    Route::get('/invoices/{invoice}/print', [InvoiceController::class, 'print'])->name('invoices.print');
    Route::get('/owner-payments/{ownerPayment}/print', [OwnerPaymentController::class, 'print'])->name('owner-payments.print');
    Route::get('/expenses-report', [ExpenseController::class, 'report'])->name('expenses.report');
    Route::get('/expenses-report/download', [ExpenseController::class, 'downloadPdf'])->name('expenses.report.pdf');
    Route::post('/leases/{lease}/deposit', [LeaseController::class, 'recordDeposit'])->name('leases.deposit');
    Route::post('/leases/{lease}/pay-commission', [LeaseController::class, 'payCommission'])->name('leases.pay-commission');
    Route::get('/leases/{lease}/commission-receipt', [LeaseController::class, 'commissionReceipt'])->name('leases.commission-receipt');

    Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
    Route::get('/reports/payment-tracker', [ReportController::class, 'paymentTracker'])->name('reports.payment-tracker');
    Route::get('/reports/collection', [ReportController::class, 'collection'])->name('reports.collection');
    Route::get('/reports/owner-wise', [ReportController::class, 'ownerWise'])->name('reports.owner-wise');
    Route::get('/reports/tenant-dues', [ReportController::class, 'tenantDues'])->name('reports.tenant-dues');
    Route::get('/reports/owner-tree', [OwnerTreeController::class, 'index'])->name('reports.owner-tree');
    Route::post('/reports/owner-tree', [OwnerTreeController::class, 'store'])->name('owner-tree.store');
    Route::put('/reports/owner-tree/{ownerTree}', [OwnerTreeController::class, 'update'])->name('owner-tree.update');
    Route::delete('/reports/owner-tree/{ownerTree}', [OwnerTreeController::class, 'destroy'])->name('owner-tree.destroy');

    // Admin-only routes (edit, update, delete, settings, staff, terminate)
    Route::middleware('admin')->group(function () {
        Route::resource('owners', OwnerController::class)->only(['edit', 'update', 'destroy']);
        Route::resource('shops', ShopController::class)->only(['edit', 'update', 'destroy']);
        Route::resource('tenants', TenantController::class)->only(['edit', 'update', 'destroy']);
        Route::resource('leases', LeaseController::class)->only(['edit', 'update', 'destroy']);
        Route::resource('meter-readings', MeterReadingController::class)->parameters(['meter-readings' => 'meterReading'])->only(['edit', 'update', 'destroy']);
        Route::resource('invoices', InvoiceController::class)->only(['edit', 'update', 'destroy']);
        Route::resource('payments', PaymentController::class)->only(['edit', 'update', 'destroy']);
        Route::resource('owner-payments', OwnerPaymentController::class)->parameters(['owner-payments' => 'ownerPayment'])->only(['edit', 'update', 'destroy']);
        Route::resource('expenses', ExpenseController::class)->only(['edit', 'update', 'destroy']);

        Route::post('/leases/{lease}/terminate', [LeaseController::class, 'terminate'])->name('leases.terminate');
        Route::post('/leases/{lease}/renew', [LeaseController::class, 'renew'])->name('leases.renew');

        Route::get('/settings', [SettingController::class, 'index'])->name('settings.index');
        Route::post('/settings', [SettingController::class, 'update'])->name('settings.update');
        Route::post('/settings/categories', [SettingController::class, 'storeCategory'])->name('settings.categories.store');
        Route::put('/settings/categories/{category}', [SettingController::class, 'updateCategory'])->name('settings.categories.update');
        Route::delete('/settings/categories/{category}', [SettingController::class, 'destroyCategory'])->name('settings.categories.destroy');

        // Staff Management
        Route::resource('staff', StaffController::class)->only(['index', 'store', 'update', 'destroy']);
    });
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
