<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Cash Book Report</title>
    <style>
        @page {
            margin: 20mm;
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 11px;
            color: #1f2937;
            line-height: 1.5;
        }
        
        /* Header Section */
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding: 25px 20px;
            background: #667eea;
            border-radius: 10px;
            color: white;
        }
        .header .logo-container {
            margin-bottom: 15px;
        }
        .header .logo {
            max-width: 120px;
            max-height: 60px;
            margin: 0 auto;
        }
        .header .subtitle {
            font-size: 10px;
            opacity: 0.9;
            text-transform: uppercase;
            letter-spacing: 2px;
            margin-bottom: 8px;
        }
        .header h1 {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 5px;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .header .period {
            font-size: 12px;
            font-weight: 600;
            background: rgba(255,255,255,0.2);
            display: inline-block;
            padding: 8px 20px;
            border-radius: 20px;
            margin-top: 8px;
        }
        
        /* Summary Cards */
        .summary {
            width: 100%;
            margin-bottom: 30px;
            border-collapse: separate;
            border-spacing: 10px;
        }
        .summary td {
            width: 33.33%;
            padding: 18px 15px;
            text-align: center;
            border-radius: 8px;
            vertical-align: middle;
        }
        .summary td.cash-in {
            background: #d1fae5;
            border: 2px solid #10b981;
        }
        .summary td.cash-out {
            background: #fee2e2;
            border: 2px solid #ef4444;
        }
        .summary td.balance {
            background: #dbeafe;
            border: 2px solid #3b82f6;
        }
        .summary .label {
            font-size: 10px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
            color: #374151;
        }
        .summary .amount {
            font-size: 19px;
            font-weight: 700;
            margin-top: 2px;
            line-height: 1.2;
        }
        .summary td.cash-in .amount {
            color: #047857;
        }
        .summary td.cash-out .amount {
            color: #b91c1c;
        }
        .summary td.balance .amount.positive {
            color: #1e40af;
        }
        .summary td.balance .amount.negative {
            color: #b91c1c;
        }
        
        /* Transactions Section */
        .section-title {
            font-size: 15px;
            font-weight: 700;
            margin: 25px 0 15px 0;
            color: #111827;
            padding: 12px 15px;
            background: #f3f4f6;
            border-left: 4px solid #667eea;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        /* Table */
        table.transactions {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 25px;
        }
        table.transactions thead {
            background: #374151;
            color: white;
        }
        table.transactions th {
            padding: 11px 10px;
            text-align: left;
            font-size: 9px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border: 1px solid #1f2937;
            vertical-align: middle;
        }
        table.transactions th.text-right {
            text-align: right;
        }
        table.transactions tbody tr {
            border-bottom: 1px solid #e5e7eb;
        }
        table.transactions tbody tr:nth-child(even) {
            background: #f9fafb;
        }
        table.transactions tbody tr:nth-child(odd) {
            background: white;
        }
        table.transactions td {
            padding: 11px 10px;
            font-size: 10px;
            border-left: 1px solid #e5e7eb;
            border-right: 1px solid #e5e7eb;
            vertical-align: middle;
        }
        table.transactions td:first-child {
            font-weight: 600;
            color: #374151;
            border-left: 1px solid #e5e7eb;
        }
        table.transactions td.text-right {
            text-align: right;
        }
        
        /* Badge */
        .badge {
            display: inline-block;
            padding: 5px 11px;
            border-radius: 15px;
            font-size: 9px;
            font-weight: 700;
            letter-spacing: 0.5px;
            vertical-align: middle;
        }
        .badge.in {
            background: #10b981;
            color: white;
        }
        .badge.out {
            background: #ef4444;
            color: white;
        }
        
        /* Amount */
        .amount-in {
            color: #059669;
            font-weight: 700;
            font-size: 11px;
        }
        .amount-out {
            color: #dc2626;
            font-weight: 700;
            font-size: 11px;
        }
        
        .category {
            font-weight: 600;
            color: #4b5563;
        }
        
        .description {
            color: #6b7280;
        }
        
        /* Footer */
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 3px solid #e5e7eb;
            text-align: center;
        }
        .footer .timestamp {
            font-size: 9px;
            color: #9ca3af;
            margin-bottom: 8px;
        }
        .footer .brand {
            font-size: 11px;
            font-weight: 700;
            color: #667eea;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        /* No Data */
        .no-data {
            text-align: center;
            padding: 50px 20px;
            color: #9ca3af;
            background: #f9fafb;
            border: 2px dashed #d1d5db;
            border-radius: 8px;
            font-size: 12px;
        }
        .no-data .message {
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 5px;
            color: #6b7280;
        }
    </style>
</head>
<body>
    <?php
        $businessName = \App\Models\Setting::get('business_name', 'RentDesk');
        $businessLogo = \App\Models\Setting::get('business_logo');
    ?>
    
    <!-- Header -->
    <div class="header">
        <?php if($businessLogo): ?>
            <div class="logo-container">
                <img src="<?php echo e(public_path('storage/' . $businessLogo)); ?>" alt="Logo" class="logo">
            </div>
        <?php endif; ?>
        <div class="subtitle">Cash Book Report</div>
        <h1><?php echo e(strtoupper($businessName)); ?></h1>
        <div class="period">
            <?php if($period === 'daily'): ?>
                <?php echo e(\Carbon\Carbon::parse($date)->format('l, d F Y')); ?>

            <?php elseif($period === 'weekly'): ?>
                <?php echo e(\Carbon\Carbon::parse($date)->startOfWeek()->format('d M')); ?> - <?php echo e(\Carbon\Carbon::parse($date)->endOfWeek()->format('d M Y')); ?>

            <?php elseif($period === 'monthly'): ?>
                <?php echo e(\Carbon\Carbon::parse($date)->format('F Y')); ?>

            <?php endif; ?>
        </div>
    </div>

    <!-- Summary Cards -->
    <table class="summary">
        <tr>
            <td class="cash-in">
                <div class="label">CASH IN</div>
                <div class="amount">+ Rs <?php echo e(number_format($totalIn, 0)); ?></div>
            </td>
            <td class="cash-out">
                <div class="label">CASH OUT</div>
                <div class="amount">- Rs <?php echo e(number_format($totalOut, 0)); ?></div>
            </td>
            <td class="balance">
                <div class="label">NET BALANCE</div>
                <div class="amount <?php echo e($balance >= 0 ? 'positive' : 'negative'); ?>">
                    <?php echo e($balance >= 0 ? '+' : ''); ?> Rs <?php echo e(number_format(abs($balance), 0)); ?>

                </div>
            </td>
        </tr>
    </table>

    <!-- Transactions -->
    <div class="section-title">Transaction Details</div>

    <?php if($expenses->count() > 0): ?>
        <table class="transactions">
            <thead>
                <tr>
                    <th style="width: 12%;">DATE</th>
                    <th style="width: 13%;">TYPE</th>
                    <th style="width: 18%;">CATEGORY</th>
                    <th style="width: 41%;">DESCRIPTION</th>
                    <th class="text-right" style="width: 16%;">AMOUNT</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(\Carbon\Carbon::parse($expense->date)->format('d/m/Y')); ?></td>
                        <td>
                            <span class="badge <?php echo e($expense->type === 'cash_in' ? 'in' : 'out'); ?>">
                                <?php echo e($expense->type === 'cash_in' ? 'CASH IN' : 'CASH OUT'); ?>

                            </span>
                        </td>
                        <td class="category"><?php echo e($expense->category->name ?? '—'); ?></td>
                        <td class="description"><?php echo e($expense->description ?? '—'); ?></td>
                        <td class="text-right <?php echo e($expense->type === 'cash_in' ? 'amount-in' : 'amount-out'); ?>">
                            <?php echo e($expense->type === 'cash_in' ? '+' : '-'); ?> Rs <?php echo e(number_format($expense->amount, 0)); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php else: ?>
        <div class="no-data">
            <div class="message">No Transactions Found</div>
            <div>No records available for the selected period.</div>
        </div>
    <?php endif; ?>

    <!-- Footer -->
    <div class="footer">
        <div class="timestamp">Generated on <?php echo e(now()->format('d M Y, h:i A')); ?></div>
        <div class="brand"><?php echo e($businessName); ?> - Property Management System</div>
    </div>
</body>
</html>
<?php /**PATH C:\laragon\www\rentdesk\resources\views/expenses/report-pdf.blade.php ENDPATH**/ ?>